function [ c ] = Q_Terp( N, p )
%Gives coefficients of quadratic polynomial with vals p at given nodes.
%   N -- for Nodes -- is a (6 x 2) array with columns x and y vertices. p is a (6 x 1)
%   column vector for the value of intended spline. The output c is a row
%   vector which are the coefficients of our spline on the standard
%   (1,x,y,x*y,x^2,y^2) basis.

%Assemble the system to solve
A = [zeros(6,1)+1 N(:,1) N(:,2) N(:,1).*N(:,2) N(:,1).^(2) N(:,2).^(2)];
c = A\p;
c = c';


end

